from pydantic import BaseModel
from typing import Optional

class LanguageRegionalSettings(BaseModel):
    default_language: str                              # e.g., "English", "Spanish"
    time_zone: Optional[str] = None                    # e.g., "UTC", "Asia/Kolkata"
    date_format: Optional[str] = None                  # e.g., "MM/DD/YYYY", "DD-MM-YYYY"
    number_format: Optional[str] = None                # e.g., "1,234.56" or "1.234,56"
